<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pos extends MY_Controller {

	function __construct()
	{
		parent::__construct();

		if (!$this->loggedIn) {
			redirect('login');
		}
		$this->load->library('form_validation');
		$this->load->model('pos_model');

	}

	function index($sid = NULL, $eid = NULL)
	{

		function RealToDolar($v){
			return number_format(str_replace(",", ".", str_replace(".", "", $v)), 2, '.', '');
		}
		
		if( $this->input->get('hold') ) { $sid = $this->input->get('hold'); }
		if( $this->input->get('edit') ) { $eid = $this->input->get('edit'); }
		if( $this->input->post('eid') ) { $eid = $this->input->post('eid'); }
		if( $this->input->post('did') ) { $did = $this->input->post('did'); } else { $did = NULL; }
		if($eid && !$this->Admin){
			$this->session->set_flashdata('error', lang('access_denied'));
			redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'pos');
		}
		if (!$this->Settings->default_customer || !$this->Settings->default_category) {
			$this->session->set_flashdata('warning', lang('please_update_settings'));
			redirect('settings');
		}
		if ($register = $this->pos_model->registerData($this->session->userdata('user_id'))) {
			$register_data = array('register_id' => $register->id, 'cash_in_hand' => $register->cash_in_hand, 'register_open_time' => $register->date);
			$this->session->set_userdata($register_data);
		} else {

			if($this->session->userdata('acesso_nfc') != 1) {
				redirect("upgrade");
			}
			
			$this->session->set_flashdata('error', lang('register_not_open'));
			redirect('pos/open_register');
		}

		$suspend = $this->input->post('suspend') ? TRUE : FALSE;

		$this->form_validation->set_rules('customer', lang("customer"), 'trim|required');

		if ($this->form_validation->run() == true) {

			$quantity = "quantity";
			$product = "product";
			$unit_cost = "unit_cost";
			$tax_rate = "tax_rate";

			$date = date('Y-m-d H:i:s');
			$customer_id = $this->input->post('customer_id');
			$customer_details = $this->pos_model->getCustomerByID($customer_id);
			$customer = $customer_details->name;
			$note = $this->tec->clear_tags($this->input->post('spos_note'));

			$total = 0;
			$product_tax = 0;
			$order_tax = 0;
			$product_discount = 0;
			$order_discount = 0;
			$percentage = '%';
			$i = isset($_POST['product_id']) ? sizeof($_POST['product_id']) : 0;
			for ($r = 0; $r < $i; $r++) {
				$item_id = $_POST['product_id'][$r];
				$real_unit_price = $this->tec->formatDecimal($_POST['real_unit_price'][$r]);
				$item_quantity = $_POST['quantity'][$r];
				$item_discount = isset($_POST['product_discount'][$r]) ? $_POST['product_discount'][$r] : '0';
				$nnote = isset($_POST['product_comment'][$r]) ? $this->tec->clear_tags($_POST['product_comment'][$r]) : '';
				if (isset($item_id) && isset($real_unit_price) && isset($item_quantity)) {
					$product_details = $this->site->getProductByID($item_id);
					$unit_price = $real_unit_price;

					$pr_discount = 0;
					if (isset($item_discount)) {
					    $discount = $item_discount;
					    $dpos = strpos($discount, $percentage);
					    if ($dpos !== false) {
					        $pds = explode("%", $discount);
					        $pr_discount = (($this->tec->formatDecimal($unit_price)) * (Float)($pds[0])) / 100;
					    } else {
					        $pr_discount = $this->tec->formatDecimal($discount);
					    }
					}
					$unit_price = $this->tec->formatDecimal($unit_price - $pr_discount);
					$item_net_price = $unit_price;
					$pr_item_discount = $this->tec->formatDecimal($pr_discount * $item_quantity);
					$product_discount += $pr_item_discount;

					$pr_item_tax = 0; $item_tax = 0; $tax = "";
						if (isset($product_details->tax) && $product_details->tax != 0) {

					        if ($product_details && $product_details->tax_method == 1) {
					            $item_tax = $this->tec->formatDecimal((($unit_price) * $product_details->tax) / 100);
					            $tax = $product_details->tax . "%";
					        } else {
					            $item_tax = $this->tec->formatDecimal((($unit_price) * $product_details->tax) / (100 + $product_details->tax));
					            $tax = $product_details->tax . "%";
					            $item_net_price -= $item_tax;
					        }

						    $pr_item_tax = $this->tec->formatDecimal($item_tax * $item_quantity);

						}

					$product_tax += $pr_item_tax;
					$subtotal = (($item_net_price * $item_quantity) + $pr_item_tax);

					$products[] = array(
						'product_id' => $item_id,
						'quantity' => $item_quantity,
						'unit_price' => $unit_price,
						'net_unit_price' => $item_net_price,
						'discount' => $item_discount,
						'item_discount' => $pr_item_discount,
						'tax' => $tax,
						'item_tax' => $pr_item_tax,
						'subtotal' => $subtotal,
						'real_unit_price' => $real_unit_price,
						'cost' => $product_details->cost,
						'note' => ($nnote!="undefined")? $nnote : ""
						);

					$total += $item_net_price * $item_quantity;

				}
			}
			if (empty($products)) {
				$this->form_validation->set_rules('product', lang("order_items"), 'required');
			} else {
				krsort($products);
			}

			if ($this->input->post('order_discount')) {
				$order_discount_id = $this->input->post('order_discount');
				$opos = strpos($order_discount_id, $percentage);
				if ($opos !== false) {
					$ods = explode("%", $order_discount_id);
					$order_discount = $this->tec->formatDecimal((($total + $product_tax) * (Float)($ods[0])) / 100);
				} else {
					$order_discount = $this->tec->formatDecimal($order_discount_id);
				}
			} else {
				$order_discount_id = NULL;
			}
			$total_discount = $this->tec->formatDecimal($order_discount + $product_discount);

			if($this->input->post('order_tax')) {
				$order_tax_id = $this->input->post('order_tax');
				$opos = strpos($order_tax_id, $percentage);
				if ($opos !== false) {
					$ots = explode("%", $order_tax_id);
					$order_tax = $this->tec->formatDecimal((($total + $product_tax - $order_discount) * (Float)($ots[0])) / 100);
				} else {
					$order_tax = $this->tec->formatDecimal($order_tax_id);
				}

			} else {
				$order_tax_id = NULL;
				$order_tax = 0;
			}

			$total_tax = $this->tec->formatDecimal($product_tax + $order_tax);
			$grand_total = $this->tec->formatDecimal($this->tec->formatDecimal($total) + $total_tax - $order_discount);
			$paid = $this->input->post('amount') ? $this->input->post('amount') : 0;
			if(!$eid) {
				$status = 'Não pago';
				if ($grand_total > $paid && $paid > 0) {
					$status = 'Parcial';
				} elseif ($grand_total <= $paid) {
					$status = 'Pago';
				}
			}
			$round_total = $this->tec->roundNumber($grand_total, $this->Settings->rounding);
			$rounding = $this->tec->formatDecimal($round_total - $grand_total);
			
			$data = array('date' => $date,
				'customer_id' => $customer_id,
				'customer_name' => $customer,
				'total' => $this->tec->formatDecimal($total),
				'product_discount' => $this->tec->formatDecimal($product_discount),
				'order_discount_id' => $order_discount_id,
				'order_discount' => $order_discount,
				'total_discount' => $total_discount,
				'product_tax' => $this->tec->formatDecimal($product_tax),
				'order_tax_id' => $order_tax_id,
				'order_tax' => $order_tax,
				'total_tax' => $total_tax,
				'grand_total' => $grand_total,
				'total_items' => $this->input->post('total_items'),
				'total_quantity' => $this->input->post('total_quantity'),
				'rounding' => $rounding,
				'paid' => $paid,
				'status' => $status,
				'created_by' => $this->session->userdata('user_id'),
				'vendedor' => $this->input->post('vendedor'),
				'note' => ($note!="undefined")? $note : ""
				);
			if($suspend) {
				$data['hold_ref'] = $this->input->post('hold_ref');
			}

			if (!$suspend && $paid) {
				$amount = $this->tec->formatDecimal($paid > $grand_total ? ($paid - $this->input->post('balance_amount')) : $paid);
				$payment = array(
					'date' => $date,
					'amount' => $amount,
					'customer_id' => $customer_id,
					'paid_by' => $this->input->post('paid_by'),
					'cheque_no' => $this->input->post('cheque_no'),
					'cc_no' => $this->input->post('cc_no'),
					'gc_no' => $this->input->post('paying_gift_card_no'),
					'cc_holder' => $this->input->post('cc_holder'),
					'cc_month' => $this->input->post('cc_month'),
					'cc_year' => $this->input->post('cc_year'),
					'cc_type' => $this->input->post('cc_type'),
					'cc_cvv2' => $this->input->post('cc_cvv2'),
					'created_by' => $this->session->userdata('user_id'),
					'note' => ($this->input->post('payment_note')!="undefined")? $this->input->post('payment_note') : "",
					'pos_paid' => $this->tec->formatDecimal($this->input->post('amount')),
					'pos_balance' => $this->tec->formatDecimal($this->input->post('balance_amount'))
					);
				$data['paid'] = $amount;

			} else {
				$payment = array();
			}

			//$this->tec->print_arrays($data, $products, $payment);
		}


		if ( $this->form_validation->run() == true && !empty($products) )
		{
			if($suspend) {
				unset($data['status'], $data['rounding']);
				if($this->pos_model->suspendSale($data, $products, $did)) {
					$this->session->set_userdata('rmspos', 1);
					$this->session->set_flashdata('message', lang("sale_saved_to_opened_bill"));
					redirect("pos");
				} else {
					$this->session->set_flashdata('error', lang("action_failed"));
					redirect("pos/".$did);
				}

			} elseif($eid) {

				unset($data['date'], $data['paid']);
				$data['updated_at'] = date('Y-m-d H:i:s');
				$data['updated_by'] = $this->session->userdata('user_id');
				if($this->pos_model->updateSale($eid, $data, $products)) {
					$this->session->set_userdata('rmspos', 1);
					$this->session->set_flashdata('message', lang("sale_updated"));
					redirect("sales");
				}
				else {
					$this->session->set_flashdata('error', lang("action_failed"));
					redirect("pos/?edit=".$eid);
				}

			} else {

				if($sale = $this->pos_model->addSale($data, $products, $payment, $did)) {
					$this->session->set_userdata('rmspos', 1);
					$msg = lang("sale_added");
					if (!empty($sale['message'])) {
						foreach ($sale['message'] as $m) {
							$msg .= '<br>' . $m;
						}
					}
					$this->session->set_flashdata('message', $msg);
					redirect("pos/view/" . $sale['sale_id']);
				}
				else {
					$this->session->set_flashdata('error', lang("action_failed"));
					redirect("pos");
				}

			}
		}
		else
		{

			if(isset($sid) && !empty($sid)) {
				$suspended_sale = $this->pos_model->getSuspendedSaleByID($sid);
				$inv_items = $this->pos_model->getSuspendedSaleItems($sid);
				krsort($inv_items);
				$c = rand(100000, 9999999);
				foreach ($inv_items as $item) {
					$row = $this->site->getProductByID($item->product_id);
					if (!$row) {
						$row = json_decode('{}');
					}
					$row->price = $item->net_unit_price+($item->item_discount/$item->quantity);
					$row->unit_price = $item->unit_price+($item->item_discount/$item->quantity)+($item->item_tax/$item->quantity);
					$row->real_unit_price = $item->real_unit_price;
					$row->discount = $item->discount;
					$row->qty = $item->quantity;
					$combo_items = FALSE;
					$ri = $this->Settings->item_addition ? $row->id : $c;
					$pr[$ri] = array('id' => $c, 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'combo_items' => $combo_items);
					$c++;
				}
				$this->data['items'] = json_encode($pr);
				$this->data['sid'] = $sid;
				$this->data['suspend_sale'] = $suspended_sale;
				$this->data['message'] = lang('suspended_sale_loaded');
			}

			if(isset($eid) && !empty($eid)) {
				$sale = $this->pos_model->getSaleByID($eid);
				$inv_items = $this->pos_model->getAllSaleItems($eid);
				krsort($inv_items);
				$c = rand(100000, 9999999);
				foreach ($inv_items as $item) {
					$row = $this->site->getProductByID($item->product_id);
					if (!$row) {
						$row = json_decode('{}');
					}
					$row->price = $item->net_unit_price;
					$row->unit_price = $item->unit_price;
					$row->real_unit_price = $item->real_unit_price;
					$row->discount = $item->discount;
					$row->qty = $item->quantity;
					$combo_items = FALSE;
					$row->quantity += $item->quantity;
					if ($row->type == 'combo') {
						$combo_items = $this->pos_model->getComboItemsByPID($row->id);
						foreach ($combo_items as $combo_item) {
							$combo_item->quantity += ($combo_item->qty*$item->quantity);
						}
					}
					$ri = $this->Settings->item_addition ? $row->id : $c;
					$pr[$ri] = array('id' => $c, 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'combo_items' => $combo_items);
					$c++;
				}
				$this->data['items'] = json_encode($pr);
				$this->data['eid'] = $eid;
				$this->data['sale'] = $sale;
				$this->data['message'] = lang('sale_loaded');
			}

			if($this->session->userdata('acesso_nfc') != 1) {
				redirect("upgrade");
			}

			$this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
			$this->data['reference_note'] = isset($sid) ? $suspended_sale->hold_ref : NULL;
			$this->data['sid'] = isset($sid) ? $sid : 0;
			$this->data['eid'] = isset($eid) ? $eid : 0;
			$this->data['vendedores'] = $this->site->getAllUsers();
			$this->data['meiopagamento'] = $this->site->getAllmeiopagamento();
			$this->data['customers'] = $this->site->getAllCustomers();
			$this->data["tcp"] = $this->pos_model->products_count($this->Settings->default_category);
			$this->data['products'] = $this->ajaxproducts($this->Settings->default_category, 1);
			$this->data['categories'] = $this->site->getAllCategories();
			$this->data['message'] = $this->session->flashdata('message');
			$this->data['suspended_sales'] = $this->site->getUserSuspenedSales();
			$this->data['page_title'] = lang('pos');
			$bc = array(array('link' => '#', 'page' => lang('pos')));
			$meta = array('page_title' => lang('pos'), 'bc' => $bc);
			$this->load->view($this->theme.'pos/index', $this->data, $meta);


		}
}

  function nfe($sale_id = NULL, $tipo = 1, $escolha = "", $origem = "pos")
  {	

		function RealToDolar($v){
			return number_format(str_replace(",", ".", str_replace(".", "", $v)), 2, '.', '');
		}

		function limparString($str){

			if($str){
				return str_replace(array(".", "/", "-", " ", "(", ")"), "", $str);
			}else{
				return "";
			}
			
			
		}

		$endpoint = APINFE_URL_BASE;

		if($this->input->get('id')){ $sale_id = $this->input->get('id'); }

		//1 nfc  2 nf
		if($tipo==1){
				
			$modelo = 65; $presenca = 1; $frete = 9; $impressao = 4;

		}elseif($tipo==2){

			$modelo = 55;  $presenca = 2; $frete = 0; $impressao = 1;

		}else{  exit; }


		//1 nfc  2 nf
		if($tipo==1 && $escolha=="emitir"){

			if($this->session->userdata('acesso_nfc') != 1 ) {
				redirect('upgrade');
			}

			if($this->session->userdata('limite_nfc') <= $this->site->getTotalNFC()) {
				redirect('upgrade');
			}

		}elseif($tipo==2  && $escolha=="emitir"){

			if($this->session->userdata('acesso_nf') != 1 ){
				redirect('upgrade');
			}

			if($this->session->userdata('limite_nf') <= $this->site->getTotalNF()) {
				redirect('upgrade');
			}

		}

		
		if($sale_id!=null && $sale_id!="0" && $origem == "pos"){ 

			if($tipo==1){
				$ultimoNF = $this->Settings->ultima_nfc;
			}else{
				$ultimoNF = $this->Settings->ultima_nf;
			}
			$inv = $this->pos_model->getSaleByID($sale_id);
			$customer_id = $inv->customer_id;
			
			$data['customer'] = $this->pos_model->getCustomerByID($customer_id);

			$origempos = true;

		}elseif($origem=="nf"){

			$inv = $this->pos_model->getNotaFiscalByID($sale_id);
			$origempos = false;

			//if($_GET["modelo"]=="") die;

		}

		
		if($inv->nf_status=="" && $inv->nf_chave=="" && $escolha=="emitir"){
		
			if($origempos && $tipo==2 && ($data['customer']->cep=="" || $data['customer']->numero=="" || $data['customer']->cf1=="" || $data['customer']->cf2=="" || $data['customer']->endereco=="" || $data['customer']->cidade=="" || $data['customer']->estado=="" || $data['customer']->codigocidade=="")){
				echo "<h3>Preencha todos os dados do Cliente para emitir a NF, edite os dados do cliente e emita novamente</h3><br><a href='".site_url('pos')."/view/".$sale_id."' style='font-size:30px;'>Voltar</a>";
				die;
			}

			// PAGAMENTO
			$cnpj_credenciadora = array();
			$bandeira = array();
			$autorizacao = array();
			$pgto = array();
			$v_pgto = array();

			if($origempos){

				
				$pgtomess = "";
				$pp = 0;
				foreach($this->pos_model->getAllSalePayments($sale_id) as $pag){

					if($pag->paid_by=='CC'){ $pgtomess .= " *** Cartão Crédito: R$ ".$pag->amount." *** "; }
					if($pag->paid_by=='stripe'){ $pgtomess .= " *** Cartão Débito: R$ ".$pag->amount." *** "; }
					if($pag->paid_by=='Cheque'){ $pgtomess .= " *** Cheque: R$ ".$pag->amount." *** "; }

					if($pag->paid_by=='cash'){
						$pg = '01';
					}else{
						$pg = '99';
					}

					$pgto[$pp] = $pg;
					$v_pgto[$pp] = $pag->pos_paid;
					$troco = $pag->pos_balance;
					$pp++;
				}

				$troco = ($troco < 0)? "0" : $troco;
		
			}else{

				$pp = 0;

				foreach($_GET["idpag"] as $idp){

					$pag = $_GET["tpag"][$idp];

					$pag = strval(str_pad($pag, 2, '0', STR_PAD_LEFT));
					$pgto[$pp] = $pag;
					$v_pgto[$pp] = RealToDolar($_GET["vpag"][$idp]);
					if($pag=="03" || $pag == "04"){
						$cnpj_credenciadora[$pp] = $_GET["cnpjCredenciadora"][$idp];
						$bandeira[$pp] = $_GET["tband"][$idp];
						$autorizacao[$pp] = $_GET["cAut"][$idp];
					}
					$pp++;
				}

				$troco = ($this->input->get('troco')=="" || RealToDolar($this->input->get('troco')) < 0)? "0" : RealToDolar($this->input->get('troco'));

			}
			

			// PEDIDO

			if($this->input->get('data_entrada_saida')!="" && $this->input->get('hora_entrada_saida')!=""){
				$data_entrada_saida = $this->input->get('data_entrada_saida')." ".$this->input->get('hora_entrada_saida').":00";
			}elseif($this->input->get('data_entrada_saida_auto')=="on"){
				$data_entrada_saida = "auto";
			}else{
				$data_entrada_saida = "";
			}

			$ultimoNF = ($this->input->get('numero')=="")? $ultimoNF : $this->input->get('numero');

			$vat_no = limparString( $this->Settings->vat_no);
			$ie = limparString( $this->Settings->ie);
			$im = limparString( $this->Settings->im);
			$tel = limparString( $this->Settings->phone_number);
			$cep = limparString( $this->Settings->postal_code);

			if($this->input->get('destinooperacao')!=""){
				$destinooperacao = 	$this->input->get('destinooperacao');
			}else{
				$destinooperacao = 	"1";
			}
			

			$data_nfe = array(
				'ID' => $sale_id, 
				'NF' => $ultimoNF,
				'operacao' => 1, 
				'destinooperacao' => $destinooperacao,
				'serie' => ($this->input->get('serie')=="")? 1 : $this->input->get('serie'), 
				'natureza_operacao' => ($this->input->get('natureza_operacao')=="")? 'Venda' : $this->input->get('natureza_operacao'), 
				'modelo' => $modelo, 
				'emissao' => 1,
				'data_entrada_saida' => ($data_entrada_saida)? $data_entrada_saida: "",
				'finalidade' => ($this->input->get('finalidade')=="")? 1 : $this->input->get('finalidade'), 
				'impressao' => $impressao,  
				'tipooperacao' => 1,
				'consumidorfinal' => ($this->input->get('indFinal')=="")? "1" : $this->input->get('indFinal'),
				"tpAmb" => strval($this->Settings->tpAmb),  // TIPO DE AMBIENTE: 1 - PRODUCAO / 2 - HOMOLOGACAO
				"razaosocial" => strval($this->Settings->razaosocial),
				"cnpj" => strval($vat_no),
				"fantasia" => strval($this->Settings->fantasia), 
				"ie" => strval($ie), 
				"im" => strval($im),
				//"cnae" => strval($this->Settings->cnae),
				"crt" => strval($this->Settings->crt),
				"rua" => strval($this->Settings->address),
				"numero" => strval($this->Settings->numero),
				"bairro" => strval($this->Settings->bairro),
				"cidade" => strval($this->Settings->city),
				"ccidade" => strval($this->Settings->ccidade), 
				"cep" => strval($cep), 
				"siglaUF" => strval($this->Settings->estado), 
				"codigoUF" => strval($this->Settings->codigoUF), 
				"fone" => strval($tel),
				"tokenIBPT" => strval($this->Settings->tokenIBPT), 
				"CSC" => strval($this->Settings->CSC), 
				"CSCid" => strval($this->Settings->CSCid),
				"certificado" => strval($this->Settings->certificado), 
				"certificadosenha" => strval($this->Settings->certificadosenha),
				'pedido' => array(
					'pagamento' => 0, 
					'presenca' => ($this->input->get('presenca')=="")? $presenca : $this->input->get('presenca'),  
					'modalidade_frete' => ($this->input->get('modalidade_frete')=="")? $frete : $this->input->get('modalidade_frete'),  
					'frete' => ($this->input->get('frete')=="")? '0.00' : RealToDolar($this->input->get('frete')), 
					'desconto' => ($this->input->get('desconto')=="")? $inv->total_discount : RealToDolar($this->input->get('desconto')), 
					'total' => ($this->input->get('valorNota')=="")? $inv->total : RealToDolar($this->input->get('valorNota')), 
					'troco' => $troco,
					'outras_despesas' => ($this->input->get('outrasDespesas')=="")? "" : RealToDolar($this->input->get('outrasDespesas')),
					'forma_pagamento' => $pgto,
					'valor_pagamento' => $v_pgto,
					'cnpj_credenciadora' => $cnpj_credenciadora,
					'bandeira' => $bandeira,
					'autorizacao' => $autorizacao, 
					'tipo_integracao' => ($this->input->get('tpIntegra')=="")? "2" : $this->input->get('tpIntegra'),
				),
			);


			// TECNICO RESPONSAVEL
			if(tecCNPJ!=""){

				$data_nfe["tecnico"] = array(
						'cnpj' => tecCNPJ,
						'contato'=> tecxContato,
						'email'=> tecemail,
						'fone'=> tecfone,
						'csrt'=> tecCSRT,
						'idcsrt'=> tecidCSRT
				);
			}



			// TRANSPORTE

			$transdoc = limparString( $this->input->get('cnpjTransportador'));

			if(strlen($transdoc)==11){
				$t1 = 'cpf';
				$t2 = 'nome_completo';
			}else{
				$t1 = 'cnpj';
				$t2 = 'razao_social';
			}

			$data_nfe["transporte"] = array(
				$t2 => $this->input->get('transportador'),
				'placa' => $this->input->get('placa'),
				'uf_veiculo' => $this->input->get('ufVeiculo'),
				'rntc' => $this->input->get('rntc'),
				 $t1 => limparString($this->input->get('cnpjTransportador')),
				'ie' => limparString($this->input->get('ieTransportador')), //  0 = isento
				'endereco' => $this->input->get('enderecoTransportador'),
				'cidade' => $this->input->get('municipioTransportador'),
				'uf' => $this->input->get('ufTransportador'),
				'seguro' => RealToDolar($this->input->get('seguro')),
				'volume' => $this->input->get('qtdVolumes'),
				'especie' => $this->input->get('especie'),
				'marca' => $this->input->get('marca'),
				'numeracao' => $this->input->get('nroDosVolumes'),
				'peso_bruto' => $this->input->get('pesoBruto'),
				'peso_liquido' => $this->input->get('pesoLiquido')
			);

			
			$costumer = "";
			if($this->input->get('nomeVendedor')!=""){ $costumer .= " | Vendedor: ".$this->input->get('nomeVendedor')." ";}
			if($pgtomess) $costumer .= $pgtomess;

			// CLIENTE
			if($data['customer']->tipo_cad==1 || $this->input->get('tipoPessoa')=="F"){
				$d1 = 'cpf';
				$d2 = 'contato';
				$d3 = 'rg';
				$tipoPessoa = "F";
			}elseif($data['customer']->tipo_cad==2 || $this->input->get('tipoPessoa')=="J"){
				$d1 = 'cnpj';
				$d2 = 'contato';
				$d3 = 'ie';
				$tipoPessoa = "J";
			}elseif($data['customer']->tipo_cad==3){
				$d1 = 'id_estrangeiro';
				$d2 = 'contato';
				$d3 = 'ie_extran';
				$tipoPessoa = "E";

			}

			if($tipo==2){	// CLIENTE NF

				$cep = ($data['customer']->cep=="")? $this->input->get('cep') : $data['customer']->cep;
				$cep = limparString( $cep);

				$data_nfe['cliente'] = array(
					$d1 => ($data['customer']->cf1=="")? limparString($this->input->get('cnpj')) : limparString($data['customer']->cf1), 
					$d2 => ($data['customer']->name=="")? $this->input->get('contato') : $data['customer']->name, 
					$d3 => ($data['customer']->cf2=="")? limparString($this->input->get('ie')) : limparString($data['customer']->cf2), 
					'endereco' => ($data['customer']->endereco=="")? $this->input->get('endereco') : $data['customer']->endereco,
					'complemento' => ($data['customer']->complemento=="")? $this->input->get('complemento') : $data['customer']->complemento, 
					'numero' => ($data['customer']->numero=="")? $this->input->get('enderecoNro') : $data['customer']->numero, 
					'bairro' => ($data['customer']->bairro=="")? $this->input->get('bairro') : $data['customer']->bairro, 
					'cidade' => ($data['customer']->cidade=="")? $this->input->get('cidade') : $data['customer']->cidade, 
					'cidade_cod' => ($data['customer']->codigocidade=="")? $this->input->get('cidade_cod') : $data['customer']->codigocidade, 
					'uf' => ($data['customer']->estado=="")? $this->input->get('uf') : $data['customer']->estado, 
					'cep' => $cep,
					'telefone' => ($data['customer']->phone=="")? $this->input->get('fone') : $data['customer']->phone, 
					'email' => ($data['customer']->email=="")? $this->input->get('email') : $data['customer']->email,
					'indIEDest' => $this->input->get('indIEDest'),
					'cod_pais' => ($this->input->get('cod_pais')=="")? "1058" : $this->input->get('cod_pais'),
					'nome_pais' => ($this->input->get('nome_pais')=="")? "BRASIL" : $this->input->get('nome_pais'),
					'tipoPessoa' => $tipoPessoa
				);
				
			}else{ // CLIENTE NFC
				
			
				if($origempos && ($data['customer']->numero!="" || $data['customer']->cf1!="" || ($data['customer']->cf2!="" && $tipoPessoa=="J") || $data['customer']->endereco!="" || $data['customer']->cidade!="" || $data['customer']->estado!="" || $data['customer']->codigocidade!="")){
					
					$cep = ($data['customer']->cep=="")? $this->input->get('cep') : $data['customer']->cep;
					$cep = limparString($cep);

					$data_nfe['cliente'] = array(
						$d1 => ($data['customer']->cf1=="")? limparString($this->input->get('cnpj')) : limparString($data['customer']->cf1), 
						$d2 => ($data['customer']->name=="")? $this->input->get('contato') : $data['customer']->name, 
						$d3 => ($data['customer']->cf2=="")? limparString($this->input->get('ie')) : limparString($data['customer']->cf2), 
						'endereco' => ($data['customer']->endereco=="")? $this->input->get('endereco') : $data['customer']->endereco,
						'complemento' => ($data['customer']->complemento=="")? $this->input->get('complemento') : $data['customer']->complemento, 
						'numero' => ($data['customer']->numero=="")? $this->input->get('enderecoNro') : $data['customer']->numero, 
						'bairro' => ($data['customer']->bairro=="")? $this->input->get('bairro') : $data['customer']->bairro, 
						'cidade' => ($data['customer']->cidade=="")? $this->input->get('cidade') : $data['customer']->cidade, 
						'cidade_cod' => ($data['customer']->codigocidade=="")? $this->input->get('cidade_cod') : $data['customer']->codigocidade, 
						'uf' => ($data['customer']->estado=="")? $this->input->get('uf') : $data['customer']->estado, 
						'cep' => $cep, 
						'telefone' => ($data['customer']->phone=="")? $this->input->get('fone') : $data['customer']->phone, 
						'email' => ($data['customer']->email=="")? $this->input->get('email') : $data['customer']->email,
						'indIEDest' => $this->input->get('indIEDest'),
						'cod_pais' => ($this->input->get('cod_pais')=="")? "1058" : $this->input->get('cod_pais'),
						'nome_pais' => ($this->input->get('nome_pais')=="")? "BRASIL" : $this->input->get('nome_pais'),
						'tipoPessoa' => $tipoPessoa
					);

				}else{
					
					// CPF na nota
					$cpfnanota = limparString($data['customer']->cf1);
					if($cpfnanota !="" && strlen($cpfnanota)==11){
						$data_nfe['cliente'] = array(
							'cpf' => $cpfnanota, 
							'indIEDest' => "9",
							'tipoPessoa' => "F"
						);
					}
					
					if($data['customer']->name!="") $costumer .= ' | Cliente: '.$data['customer']->name;
					if($data['customer']->endereco!="") $costumer .= ' | Endereço:'.$data['customer']->endereco;
					if($data['customer']->cidade!="") $costumer .= ', '.$data['customer']->cidade;
					if($data['customer']->estado!="") $costumer .= ', '.$data['customer']->estado;
					if($data['customer']->pais!="") $costumer .= ', '.$data['customer']->pais; 
					if($data['customer']->cep!="") $costumer .= ', '.$data['customer']->cep; 
					if($data['customer']->phone!="") $costumer .= ' | Telefone: '.$data['customer']->phone;
					if($data['customer']->email!="") $costumer .= ' | Email: '.$data['customer']->email;

				}

				$complementosNfe = $this->Settings->footer;
	
			}
				
				// PRODUTOS
				if($origempos){
					$x = 0;
					foreach($this->pos_model->getAllSaleItems($sale_id) as $prod){	

						if($prod->product_imposto!=""){
							$impostos = $this->pos_model->getImpostos($prod->product_imposto);
						}
						
						$data_nfe['produtos'][$x] = array(
							'item' => $prod->product_code, 
							'nome' => $prod->product_name, 
							'ean' => '',
							'ncm' => $prod->product_ncm, 
							'cest' => $prod->product_cest,
							'unidade' => $prod->product_unit, 
							'quantidade' => $prod->quantity, 
							'peso' => '0.200',
							'origem' => $prod->product_origem, 
							'desconto' => $prod->discount,
							'subtotal' => number_format($prod->unit_price, 2, '.', ''), 
							'total' => number_format(($prod->unit_price * $prod->quantity), 2, '.', ''),
						);

						$data_nfe['produtos'][$x]['tipo_item'] = $impostos->tipo;

						$data_nfe['produtos'][$x]['impostos']['icms']['origem'] = $prod->product_origem;
						$codigo_cfop = ($destinooperacao==1)? $prod->cfop : $prod->cfop2;
						$data_nfe['produtos'][$x]['impostos']['icms']['codigo_cfop'] = $codigo_cfop;

						if($impostos->regras!="" && $prod->product_imposto){

							$js = json_decode($impostos->regras, true);

							$data_nfe['produtos'][$x]['tipo_item'] = $impostos->tipo;

							foreach($js as $a => $b){
								if(is_array($b)){
									foreach($b as $c => $d){
										if(is_array($d)){
											foreach($d as $e => $f){
												$data_nfe['produtos'][$x][$a][$c][$e] = $f;
											}
										}else{
											$data_nfe['produtos'][$x][$a][$c] = $d;
										}
									}
								}else{
									$data_nfe['produtos'][$x] = $b;
								}
							}
						}
						
						$x++;

					}

				}else{

					$x = 0;
					foreach($_GET["produtoId"] as $prod){	

						$product = $this->site->getProductByID($_GET["produtoId"][$x]);

						if($product->imposto!=""){
							$impostos = $this->pos_model->getImpostos($product->imposto);
						}

						$produnit_price = RealToDolar($_GET["precounitario"][$x]);

						$data_nfe['produtos'][$x] = array(
							'item' => $_GET["codigo"][$x], // ITEM do produto
							'nome' => $_GET["produto"][$x], 
							'codigo' => $_GET["codigo"][$x],
							'ean' => '',
							'ncm' => $_GET["ncm"][$x], 
							'cest' => $product->cest,
							'unidade' => $_GET["un"][$x], 
							'quantidade' => RealToDolar($_GET["quantidade"][$x]), 
							'peso' => '0.200',
							'desconto' => "",
							'subtotal' => number_format($produnit_price, 2, '.', ''), 
							'total' => number_format(($produnit_price * RealToDolar($_GET["quantidade"][$x])), 2, '.', '')
						);

						$data_nfe['produtos'][$x]['impostos']['icms']['origem'] = $product->origem;
						$codigo_cfop = ($destinooperacao==1)? $product->cfop : $product->cfop2;
						$data_nfe['produtos'][$x]['impostos']['icms']['codigo_cfop'] = $codigo_cfop;

						if($impostos->regras!="" && $product->imposto){
							$js = json_decode($impostos->regras, true);

							$data_nfe['produtos'][$x]['tipo_item'] = $impostos->tipo;

							foreach($js as $a => $b){
								if(is_array($b)){
									foreach($b as $c => $d){
										if(is_array($d)){
											foreach($d as $e => $f){
												$data_nfe['produtos'][$x][$a][$c][$e] = $f;
											}
										}else{
											$data_nfe['produtos'][$x][$a][$c] = $d;
										}
									}
								}else{
									$data_nfe['produtos'][$x] = $b;
								}
							}
						}
						$x++;
					}

				}
				
				// INFORMACOES DO CLIENTE
				$data_nfe['pedido']['informacoes_complementares'] = $complementosNfe." ".$_GET["observacoes"]." ".$costumer;
				
				// Contingencia
				if(!$this->pos_model->is_connected()){ 
					$data_nfe['conti'] = 1;
				}
		
				$fields_string = http_build_query($data_nfe);
				
					if(ENVIRONMENT == "development"){
						print_r($data_nfe);
						echo "<br><br><br>:: URL ::<br>";
						echo $endpoint."gerador/Emissor.php?".$fields_string;
						echo "<br><br><br>::: DADOS :::<br>";
						foreach(explode("&", $fields_string) as $k => $v) {
							$x2 = explode("=", $v);
							echo urldecode($x2[0])." = ". urldecode($x2[1]) . "<br>";
						}
						die;
					}

				$ch = curl_init();
				curl_setopt($ch,CURLOPT_URL, $endpoint."gerador/Emissor.php");
				curl_setopt($ch,CURLOPT_POST, count($data_nfe, COUNT_RECURSIVE));
				curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$response_server = curl_exec($ch);
				$response = json_decode($response_server);
				curl_close($ch);
				
			if (isset($response->error)){
				if ($response->update!='0') {
					
					// DONT NEED TO UPDATE THE NEXT NOTE
				}
				
				echo '<h2>Erro na emissão: '.$response->error.'</h2>';
				if (isset($response->log)){
					echo '<h3>Log:</h3>';
					echo '<ul>';
					foreach ($response->log as $erros){
						foreach ($erros as $erro) {
							echo '<li>'.$erro.'</li>';
						}
					}
					echo '</ul>';
				}

			}elseif(!$response){
				
				echo '<h2>Erro no servidor ao emitir</h2>';
				var_dump($response_server);
			
			}else {

				if($tipo==1){
					$this->pos_model->UpdateLastNFCNumero($ultimoNF);
				}else{
					$this->pos_model->UpdateLastNFNumero($ultimoNF);
				}
				
				$status = (string) $response->status; // aprovado, reprovado, cancelado, em processamento ou contingencia
				$nfe = (int) $response->nfe; // número da NF-e
				$serie = (int) $response->serie; // número de série
				$recibo = (int) $response->recibo; // número do recibo
				$chave = $response->chave; // número da chave de acesso
				$xml = (string) $response->xml; // URL do XML
				
				
				if($status=="em processamento"){
					$danfe = $recibo;
					// salva o recibo no campo danfe
				}

				// fazer upload dos dados
				if($tipo==1){ // NFC
					$this->pos_model->UpdateDadosNFC($sale_id, $status, $nfe, $chave, $danfe, $xml, 65);
					$user = $this->session->userdata('user_id');
					// também adicionamos a nota fiscal NFC ao listado de notas fiscais
					$this->pos_model->InsertDadosNF($status, $nfe, $chave, $danfe, $xml, 65, $user, $customer_id);
				}else{
					// todo: inserir em vendas
					$user = $this->session->userdata('user_id');
					$idcont = $this->input->get('idContato');
					$this->pos_model->InsertDadosNF($status, $nfe, $chave, $danfe, $xml, 55, $user, $idcont);
				}

				if($status == "em processamento"){
					$cont = "tipo=emprocessamento&";
				}
			
				if($status == "contingencia"){
					$cont = "tipo=conti&";
				}

				// Envio de email
				if($status == "aprovado"){

					$enviopara = ($data['customer']->email=="" && $tipo==1)? $this->input->get('email') : $data['customer']->email;

					if($enviopara!="" && $tipo==2){

						$url = $endpoint.'envio_email_nf.php';
						$fieldsEM = array(
							'para' => urlencode($enviopara),
							'danfe' => urlencode($endpoint ."danfe/?".$cont."chave=".$chave."&logo="),
							'xml' => urlencode($endpoint."gerador/xml/autorizadas/$chave.xml")
						);

						foreach($fieldsEM as $key=>$value) { $fieldsEM_string .= $key.'='.$value.'&'; }
						$fieldsEM_string = rtrim($fieldsEM_string, '&');

						$ch = curl_init();
						curl_setopt($ch,CURLOPT_URL, $url);
						curl_setopt($ch,CURLOPT_POST, count($fieldsEM));
						curl_setopt($ch,CURLOPT_POSTFIELDS, $fieldsEM_string);
						$result = curl_exec($ch);
						curl_close($ch);

					}

					header("location: ". $endpoint ."danfe/?".$cont."chave=".$chave."&logo=");
					exit;

				}elseif($status == "em processamento"){
					
					$cont = "tipo=emprocessamento&";
					header("location: ". $endpoint ."danfe/?".$cont."chave=".$chave."&logo=");
					exit;

				}elseif($status == "contingencia"){
					$cont = "tipo=conti&";
					header("location: ". $endpoint ."danfe/?".$cont."chave=".$chave."&logo=");
					exit;

				} else{

					echo "<h2>Sua nota não foi aprovado no momento.<br>Status: $status <br>Entre em contato com o suporte.<h2>";
					die;

				}	

			}

		}	
		else	
		{ 

			if($escolha==1){
				
				// Imprimir Danfe
				if($inv->nf_status=="contingencia") $cont = "tipo=conti&";
				if($inv->nf_status=="cancelado") $cont = "tipo=cancelada&";
				if($inv->nf_status=="em processamento") $cont = "tipo=emprocessamento&";

				header("location: ". $endpoint ."danfe/index.php?".$cont."chave=".$inv->nf_chave);
				exit;
			
			}elseif($escolha==2){
			
				header("location: ". $endpoint . $inv->nf_xml);
				exit;
			
			}elseif($escolha==3){
				
				echo "<style>select{font-size:16px;}.btn{ font-size: 22px;color: #FFF; padding: 6px;background: #1db31d;margin: 10px;font-family: sans-serif;font-weight: bold;border-radius: 4px;text-decoration: none; }</style>";
			
			
				$vat_no = limparString( $this->Settings->vat_no);
				$ie = limparString( $this->Settings->ie);
				$im = limparString( $this->Settings->im);
				$tel = limparString( $this->Settings->phone_number);
				
				$data_sett = array(
					"tpAmb" => strval($this->Settings->tpAmb), 
					"razaosocial" => strval($this->Settings->razaosocial),
					"cnpj" => strval($vat_no),
					"fantasia" => strval($this->Settings->fantasia), 
					"ie" => strval($ie), 
					"im" => strval($im),
					//"cnae" => strval($this->Settings->cnae),
					"crt" => strval($this->Settings->crt),
					"rua" => strval($this->Settings->address),
					"numero" => strval($this->Settings->numero),
					"bairro" => strval($this->Settings->bairro),
					"cidade" => strval($this->Settings->city),
					"ccidade" => strval($this->Settings->ccidade), 
					"cep" => strval($this->Settings->postal_code), 
					"siglaUF" => strval($this->Settings->estado), 
					"codigoUF" => strval($this->Settings->codigoUF), 
					"fone" => strval($tel),
					"tokenIBPT" => strval($this->Settings->tokenIBPT), 
					"CSC" => strval($this->Settings->CSC), 
					"CSCid" => strval($this->Settings->CSCid),
					"certificado" => strval($this->Settings->certificado), 
					"certificadosenha" => strval($this->Settings->certificadosenha)
				);
				$fields_sett = http_build_query($data_sett);
	
				echo "<form method='POST' action='". $endpoint ."gerador/CancelarNota.php'>
				Selecione o motivo do cancelamento:<br><br>
				<select name='motivo'><option value='ERRO PREENCIMENTO DADOS'>ERRO PREENCIMENTO DADOS</option>
				<option value='REFAZER COM PRECO MENOR'>REFAZER COM PRECO MENOR</option>
				<option value='ERRO IMPRESSAO'>ERRO IMPRESSAO</option>
				<option value='PEDIDO DE TESTE'>PEDIDO DE TESTE</option>
				<option value='CLIENTE CANCELOU A COMPRA'>CLIENTE CANCELOU A COMPRA</option>
				</select><br><br>
				<input type='submit' class='btn' value='Cancelar Nota'>
				<input name='ID' type='hidden' value='".$sale_id."'>
				<input name='nfe' type='hidden' value='".$inv->nf_numero."'>
				<input name='chave' type='hidden' value='".$inv->nf_chave."'>
				<input name='endpoint' type='hidden' value='". $endpoint ."'>";


				foreach($data_sett as $k => $v) {
					echo "<input type='hidden' name='$k' value='$v'>";
				}
	
				echo "</form>";
		
			}else{
				// SELECIONAR OPCAO
				
				echo "<style>a{ font-size: 22px;color: #FFF; padding: 6px;background: #1db31d;margin: 10px;font-family: sans-serif;font-weight: bold;border-radius: 4px;text-decoration: none; }</style>";
				
				if($inv->nf_status==""){
					echo "<a id='btn1' onClick='Clique()' href='".site_url('pos')."/nfe/".$sale_id."/1/emitir/$origem'>Emitir NFC-e</a>";
					//echo "<a id='btn2' onClick='Clique()' href='".site_url('pos')."/nfe/".$sale_id."/2/emitir/$origem'>Emitir NF-e</a>";
					echo '<script>function Clique(){  document.getElementById("btn1").disabled = true;  }</script>';
				}else{
					
					echo "Estado da nota: <b>".$inv->nf_status."</b><br><br>";
					
					if($inv->nf_status=="cancelado"){
				
						echo "<a href='".site_url('pos')."/nfe/".$sale_id."/1/1/$origem'>Imprimir DANFE</a><a href='".site_url('pos')."/nfe/".$sale_id."/1/2/$origem'>XML</a><br><br><br><br><a href='javascrtipt:void(0)' onclick='window.close()'>Fechar Janela</a>";
					
					} elseif($inv->nf_status=="negado"){
				
						echo "<a href='javascrtipt:void(0)' onclick='window.close()'>Fechar Janela</a>";
					
							
					}else{
						echo "<a href='".site_url('pos')."/nfe/".$sale_id."/1/1/$origem'>Imprimir DANFE</a><a href='".site_url('pos')."/nfe/".$sale_id."/1/2/$origem'>XML</a><a href='".site_url('pos')."/nfe/".$sale_id."/1/3/$origem'>Cancelar Nota</a><br><br><br><br><a href='javascrtipt:void(0)' onclick='window.close()'>Fechar Janela</a>";
					}
					
				}
		
			}

		}
			
	}
  
   
   function nfe_updatadados() {

		$endpoint = APINFE_URL_BASE;
		
		$status = $this->input->get('status'); // aprovado, reprovado, cancelado, processamento ou contingencia
		$nfe = (int) $this->input->get('nfe'); // número da NF-e
    	$id = (int) $this->input->get('ID'); // número da NF-e
		$serie = (int) $this->input->get('serie'); // número de série
		$recibo = (int) $this->input->get('recibo'); // número do recibo
		$chave = $this->input->get('chave'); // número da chave de acesso
		$xml = (string) $this->input->get('xml'); // URL do XML
		$modelo = (string) $this->input->get('modelo'); // URL do XML
    
		if($status!="cancelado"){ 
			//$this->pos_model->UpdateLastNFNumero($nfe); 
		}

		if($modelo=="65"){
			// fazer upload dos dados
			$this->pos_model->UpdateDadosNFC($id, $status, $nfe, $chave, $danfe, $xml, 65);
			$this->pos_model->UpdateDadosNFbyNumero($status, $nfe, $chave, $danfe, $xml, 65);
		}else{
			// fazer upload dos dados
			$this->pos_model->UpdateDadosNFbyNumero($status, $nfe, $chave, $danfe, $xml, 55);
		}   
		
		
    	if($status=="cancelado") echo "<h1>Nota cancelada com sucesso</h1><br><br><br><br><a href='javascrtipt:void(0)' onclick='window.close()'>Fechar Janela</a>"; die;
      
		if($status=="contingencia") $cont = "tipo=conti&";
		if($status=="em processamento") $cont = "tipo=emprocessamento&";
		if($status!="cancelado") header("location: ". $endpoint  ."danfe/index.php?".$cont."chave=".$chave); exit;
  }
  
  function nfe_contingencia() {
    
    $erross = array();

	$endpoint = APINFE_URL_BASE;

	function limparString($str){
		if($str){
			return str_replace(array(".", "/", "-", " ", "(", ")"), "", $str);
		}else{
			return "";
		}
	}
      
    foreach($this->pos_model->getAllSalesContingencia() as $v){
	  
		$vat_no = limparString( $this->Settings->vat_no);
		$ie = limparString( $this->Settings->ie);
		$im = limparString( $this->Settings->im);
		$tel = limparString( $this->Settings->phone_number);

		$data_nfe = array(
			"tpAmb" => strval($this->Settings->tpAmb),
			"razaosocial" => strval($this->Settings->razaosocial),
			"cnpj" => strval($vat_no),
			"fantasia" => strval($this->Settings->fantasia),
			"ie" => strval($ie),
			"im" => strval($im),
			//"cnae" => strval($this->Settings->cnae),
			"crt" => strval($this->Settings->crt),
			"rua" => strval($this->Settings->address),
			"numero" => strval($this->Settings->numero),
			"bairro" => strval($this->Settings->bairro),
			"cidade" => strval($this->Settings->city),
			"ccidade" => strval($this->Settings->ccidade),
			"cep" => strval($this->Settings->postal_code),
			"siglaUF" => strval($this->Settings->estado),
			"codigoUF" => strval($this->Settings->codigoUF),
			"fone" => strval($tel),
			"tokenIBPT" => strval($this->Settings->tokenIBPT),
			"CSC" => strval($this->Settings->CSC),
			"CSCid" => strval($this->Settings->CSCid),
			"certificado" => strval($this->Settings->certificado),
			"certificadosenha" => strval($this->Settings->certificadosenha)
		);

	  	$data_nfe["emissao"] = ($v->nf_status=="contingencia") ? "conti" : "processa";
		$data_nfe["ID"] = $v->id; 
		$data_nfe["chave"] = $v->nf_chave; 
		$data_nfe["nfe"] = $v->nf_numero; 
		$data_nfe["recibo"] = $v->nf_danfe;
      
          $fields_string = http_build_query($data_nfe);
          $ch = curl_init();
          curl_setopt($ch,CURLOPT_URL, $endpoint."gerador/Emissor.php");
          curl_setopt($ch,CURLOPT_POST, count($data_nfe, COUNT_RECURSIVE));
          curl_setopt($ch,CURLOPT_POSTFIELDS, $fields_string);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
          $response_server = curl_exec($ch);
          $response = json_decode($response_server);
          curl_close($ch);
      
     
      if (isset($response->error)){
       
        	$erross[$v->nf_numero] = $response->error;
			//echo '<h2>Erro: '.$response->error.'</h2>';
			if (isset($response->log)){
			  echo '<h3>Log:</h3>';
			  echo '<ul>';
			  foreach ($response->log as $erros){
				foreach ($erros as $erro) {
				  echo '<li>'.$erro.'</li>';
				}
			  }
			  echo '</ul>';
			}
			
			if($response->lote == 104){

				if($v->nf_modelo=="65"){
					// fazer upload dos dados
					$this->pos_model->UpdateDadosNFC($v->id, "reprovado", $v->nf_numero, $v->nf_chave, $v->nf_danfe, "", 65);
					$this->pos_model->UpdateDadosNFbyNumero("reprovado", $v->nf_numero, $v->nf_chave, $v->nf_danfe, "", 65);
				}else{
					// fazer upload dos dados
					$this->pos_model->UpdateDadosNF($v->id, "reprovado", $v->nf_numero, $v->nf_chave, $v->nf_danfe, "", 55);
				}
			 
			
			}

      }elseif(!$response){

		echo '<h2>Erro no servidor ao emitir</h2>';
		var_dump($response);

      } else {

        $status = (string) $response->status; // aprovado, reprovado, cancelado, em processamento ou contingencia
        $nfe = (int) $response->nfe; // número da NF-e
        $serie = (int) $response->serie; // número de série
        $recibo = (int) $response->recibo; // número do recibo
        $chave = $response->chave; // número da chave de acesso
        $xml = (string) $response->xml; // URL do XML
        
        if($status=="em processamento"){
			$danfe = $recibo;
		}
        
		if($v->nf_modelo=="65"){
			// fazer upload dos dados
			$this->pos_model->UpdateDadosNFC($v->id, $status, $nfe, $chave, $danfe, $xml, 65);
			$this->pos_model->UpdateDadosNFbyNumero($status, $nfe, $chave, $danfe, $xml, 65);
		}else{
			// fazer upload dos dados
			$this->pos_model->UpdateDadosNF($v->id, $status, $nfe, $chave, $danfe, $xml, 55);
		}

        if($status=="aprovado"){
			echo "<script>window.open('".$endpoint ."danfe/index.php?chave=".$v->nf_chave."', '_blank');</script>";
		}

      }
       
    }

      if(!empty($erross)) foreach($erross as $key => $ers) echo "NF Número: ". $key . " | Erro: ".$ers."<br>";

  }
  
  
  function nfe_error() {
  
    echo $this->input->get('dados');
    echo "<br><br><a onclick='window.close()'>Fechar</a>";
  
  }

	function get_product($code = NULL) {

		if($this->input->get('code')) { $code = $this->input->get('code'); }
		$combo_items = FALSE;
		if($product = $this->pos_model->getProductByCode($code)) {
			unset($product->cost, $product->details);
			$product->qty = 1;
			$product->discount = '0';
			$product->real_unit_price = $product->price;
			$product->unit_price = $product->tax ? ($product->price+(($product->price*$product->tax)/100)) : $product->price;
			if ($product->type == 'combo') {
				$combo_items = $this->pos_model->getComboItemsByPID($product->id);
			}
			echo json_encode(array('id' => str_replace(".", "", microtime(true)), 'item_id' => $product->id, 'label' => $product->name . " (" . $product->code . ")", 'row' => $product, 'combo_items' => $combo_items));
		} else {
			echo NULL;
		}

	}

	function suggestions()
	{
		$term = $this->input->get('term', TRUE);

		$rows = $this->pos_model->getProductNames($term);
		if ($rows) {
			foreach ($rows as $row) {
				unset($row->cost, $row->details);
				$row->qty = 1;
				$row->discount = '0';
				$row->real_unit_price = $row->price;
				$row->unit_price = $row->tax ? ($row->price+(($row->price*$row->tax)/100)) : $row->price;
				$combo_items = FALSE;
				if ($row->type == 'combo') {
				    $combo_items = $this->pos_model->getComboItemsByPID($row->id);
				}
				$pr[] = array('id' => str_replace(".", "", microtime(true)), 'item_id' => $row->id, 'label' => $row->name . " (" . $row->code . ")", 'row' => $row, 'combo_items' => $combo_items);
			}
			echo json_encode($pr);
		} else {
			echo json_encode(array(array('id' => 0, 'label' => lang('no_match_found'), 'value' => $term)));
		}
	}


	function registers()
	{
		$this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
		$this->data['registers'] = $this->pos_model->getOpenRegisters();
		$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => site_url('pos'), 'page' => lang('pos')), array('link' => '#', 'page' => lang('open_registers')));
		$meta = array('page_title' => lang('open_registers'), 'bc' => $bc);
		$this->page_construct('pos/registers', $this->data, $meta);
	}

	function open_register()
	{

		
		$this->form_validation->set_rules('cash_in_hand', lang("cash_in_hand"), 'trim|required');

		if ($this->form_validation->run() == true) {
			$data = array('date' => date('Y-m-d H:i:s'),
				'cash_in_hand' => str_replace(",", ".", str_replace(".", "", $this->input->post('cash_in_hand'))),
				'user_id' => $this->session->userdata('user_id'),
				'status' => 'open',
				);
		}
		if ($this->form_validation->run() == true && $this->pos_model->openRegister($data)) {
			$this->session->set_flashdata('message', lang("welcome_to_pos"));
			redirect("pos");
		} else {

			$this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');

			$bc = array(array('link' => base_url(), 'page' => lang('home')), array('link' => '#', 'page' => lang('open_register')));
			$meta = array('page_title' => lang('open_register'), 'bc' => $bc);
			$this->page_construct('pos/open_register', $this->data, $meta);
		}
	}

	function close_register($user_id = NULL)
	{
		if (!$this->Admin) {
			$user_id = $this->session->userdata('user_id');
		}
		$this->form_validation->set_rules('total_cash', lang("total_cash"), 'trim|required');
		$this->form_validation->set_rules('total_cheques', lang("total_cheques"), 'trim|required');
		$this->form_validation->set_rules('total_cc_slips', lang("total_cc_slips"), 'trim|required');

		if ($this->form_validation->run() == true) {
			if ($this->Admin) {
				$user_register = $user_id ? $this->pos_model->registerData($user_id) : NULL;
				$rid = $user_register ? $user_register->id : $this->session->userdata('register_id');
				$user_id = $user_register ? $user_register->user_id : $this->session->userdata('user_id');
			} else {
				$rid = $this->session->userdata('register_id');
				$user_id = $this->session->userdata('user_id');
			}
			$data = array('closed_at' => date('Y-m-d H:i:s'),
				'total_cash' => str_replace(",", ".", str_replace(".", "", $this->input->post('total_cash'))),
				'total_cheques' => str_replace(",", ".", str_replace(".", "", $this->input->post('total_cheques'))),
				'total_cc_slips' => str_replace(",", ".", str_replace(".", "", $this->input->post('total_cc_slips'))),
				'total_cash_submitted' => str_replace(",", ".", str_replace(".", "", $this->input->post('total_cash_submitted'))),
				'total_cheques_submitted' => str_replace(",", ".", str_replace(".", "", $this->input->post('total_cheques_submitted'))),
				'total_cc_slips_submitted' => str_replace(",", ".", str_replace(".", "", $this->input->post('total_cc_slips_submitted'))),
				'note' => $this->input->post('note'),
				'status' => 'close',
				'transfer_opened_bills' => $this->input->post('transfer_opened_bills'),
				'closed_by' => $this->session->userdata('user_id'),
			);


		} elseif ($this->input->post('close_register')) {
			$this->session->set_flashdata('error', (validation_errors() ? validation_errors() : $this->session->flashdata('error')));
			redirect("pos");
		}

		if ($this->form_validation->run() == true && $this->pos_model->closeRegister($rid, $user_id, $data)) {
			$this->session->set_flashdata('message', lang("register_closed"));
			redirect("welcome");
		} else {
			if ($this->Admin) {
				$user_register = $user_id ? $this->pos_model->registerData($user_id) : NULL;
				$register_open_time = $user_register ? $user_register->date : $this->session->userdata('register_open_time');
				$this->data['cash_in_hand'] = $user_register ? $user_register->cash_in_hand : NULL;
				$this->data['register_open_time'] = $user_register ? $register_open_time : NULL;
			} else {
				$register_open_time = $this->session->userdata('register_open_time');
				$this->data['cash_in_hand'] = NULL;
				$this->data['register_open_time'] = NULL;
			}
			$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
			$this->data['ccsales'] = $this->pos_model->getRegisterCCSales($register_open_time, $user_id);
			$this->data['cashsales'] = $this->pos_model->getRegisterCashSales($register_open_time, $user_id);
			$this->data['chsales'] = $this->pos_model->getRegisterChSales($register_open_time, $user_id);
			$this->data['stripesales'] = $this->pos_model->getRegisterStripeSales($register_open_time, $user_id);
			$this->data['totalsales'] = $this->pos_model->getRegisterSales($register_open_time, $user_id);
			$this->data['expenses'] = $this->pos_model->getRegisterExpenses($register_open_time);
			$this->data['users'] = $this->tec->getUsers($user_id);
			$this->data['suspended_bills'] = $this->pos_model->getSuspendedsales($user_id);
			$this->data['user_id'] = $user_id;
			$this->load->view($this->theme . 'pos/close_register', $this->data);
		}
	}

	function ajaxproducts( $category_id = NULL, $return = NULL) {

		if($this->input->get('category_id')) { $category_id = $this->input->get('category_id'); } elseif(!$category_id) { $category_id = $this->Settings->default_category; }
		if($this->input->get('per_page') == 'n' ) { $page = 0; } else { $page = $this->input->get('per_page'); }
		if($this->input->get('tcp') == 1 ) { $tcp = TRUE; } else { $tcp = FALSE; }

		$products = $this->pos_model->fetch_products($category_id, $this->Settings->pro_limit, $page);
		$pro = 1;
		$prods = "<div>";
		if($products) {
			if($this->Settings->bsty == 1) {
				foreach($products as $product) {
					$count = $product->id;
					if($count < 10) { $count = "0".($count /100) *100;  }
					if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
					$prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-name btn-default btn-flat product\">".$product->name."</button>";
					$pro++;
				}
			} elseif($this->Settings->bsty == 2) {
				foreach($products as $product) {
					$count = $product->id;
					if($count < 10) { $count = "0".($count /100) *100;  }
					if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
					$prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-img btn-flat product\"><img src=\"".base_url()."uploads/thumbs/".$product->image."\" alt=\"".$product->name."\" style=\"width: 110px; height: 110px;\"></button>";
					$pro++;
				}
			} elseif($this->Settings->bsty == 3) {
				foreach($products as $product) {
					$count = $product->id;
					if($count < 10) { $count = "0".($count /100) *100;  }
					if($category_id < 10) { $category_id = "0".($category_id /100) *100;  }
					$prods .= "<button type=\"button\" data-name=\"".$product->name."\" id=\"product-".$category_id.$count."\" type=\"button\" value='".$product->code."' class=\"btn btn-both btn-flat product\"><span class=\"bg-img\"><img src=\"".base_url()."uploads/thumbs/".$product->image."\" alt=\"".$product->name."\" style=\"width: 100px; height: 100px;\"></span><span><span>".$product->name."</span></span></button>";
					$pro++;
				}
			}
		} else {
			$prods .= '<h4 class="text-center text-info" style="margin-top:50px;">'.lang('category_is_empty').'</h4>';
		}

		$prods .= "</div>";

		if(!$return) {
			if(!$tcp) {
				echo $prods;
			} else {
				$category_products = $this->pos_model->products_count($category_id);
				header('Content-Type: application/json');
				echo json_encode(array('products' => $prods, 'tcp' => $category_products));
			}
		} else {
			return $prods;
		}

	}

	function view($sale_id = NULL, $noprint = NULL)
	{
		if($this->input->get('id')){ $sale_id = $this->input->get('id'); }
		$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
		$this->data['message'] = $this->session->flashdata('message');
		$inv = $this->pos_model->getSaleByID($sale_id);
		$this->tec->view_rights($inv->created_by);
		$this->load->helper('text');
		$this->data['rows'] = $this->pos_model->getAllSaleItems($sale_id);
		$this->data['customer'] = $this->pos_model->getCustomerByID($inv->customer_id);
		$this->data['inv'] = $inv;
		$this->data['sid'] = $sale_id;
		$this->data['noprint'] = $noprint;
		$this->data['modal'] = false;
		$this->data['payments'] = $this->pos_model->getAllSalePayments($sale_id);
		$this->data['meiopagamento'] = $this->site->getAllmeiopagamento();
		$this->data['created_by'] = $this->site->getUser($inv->created_by);
		$this->data['page_title'] = lang("invoice");
		$this->load->view($this->theme.'pos/view', $this->data);

	}

	function posvendanfc($sale_id = NULL, $noprint = NULL)
	{
		if($this->input->get('id')){ $sale_id = $this->input->get('id'); }
		$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
		$this->data['message'] = $this->session->flashdata('message');
		$inv = $this->pos_model->getSaleByID($sale_id);
		$this->load->helper('text');
		$this->data['inv'] = $inv;
		$this->data['sid'] = $sale_id;
		$this->data['noprint'] = $noprint;
		$this->data['modal'] = false;
		$this->data['page_title'] = lang("invoice");
		$this->load->view($this->theme.'pos/posvendanfc', $this->data);

	}

	

	function email_receipt($sale_id = NULL, $to = NULL)
	{
		if($this->input->post('id')) { $sale_id = $this->input->post('id'); }
		if($this->input->post('email')){ $to = $this->input->post('email'); }
		if(!$sale_id || !$to) { die(); }

		$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
		$this->data['message'] = $this->session->flashdata('message');
		$inv = $this->pos_model->getSaleByID($sale_id);
		$this->tec->view_rights($inv->created_by);
		$this->load->helper('text');
		$this->data['rows'] = $this->pos_model->getAllSaleItems($sale_id);
		$this->data['customer'] = $this->pos_model->getCustomerByID($inv->customer_id);
		$this->data['inv'] = $inv;
		$this->data['sid'] = $sale_id;
		$this->data['noprint'] = NULL;
		$this->data['modal'] = false;
		$this->data['payments'] = $this->pos_model->getAllSalePayments($sale_id);
		$this->data['created_by'] = $this->site->getUser($inv->created_by);

		$receipt = $this->load->view($this->theme.'pos/view', $this->data, TRUE);
		$subject = lang('email_subject');

		if($this->tec->send_email($to, $subject, $receipt)) {
			echo json_encode(array('msg' => lang("email_success")));
		} else {
			echo json_encode(array('msg' => lang("email_failed")));
		}

	}


	function register_details()
	{

		$register_open_time = $this->session->userdata('register_open_time');
		$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
		$this->data['ccsales'] = $this->pos_model->getRegisterCCSales($register_open_time);
		$this->data['cashsales'] = $this->pos_model->getRegisterCashSales($register_open_time);
		$this->data['chsales'] = $this->pos_model->getRegisterChSales($register_open_time);
		$this->data['meiopagamento'] = $this->site->getAllmeiopagamento();
		$this->data['stripesales'] = $this->pos_model->getRegisterStripeSales($register_open_time);
		$this->data['totalsales'] = $this->pos_model->getRegisterSales($register_open_time);
		$this->data['expenses'] = $this->pos_model->getRegisterExpenses($register_open_time);
		$this->load->view($this->theme . 'pos/register_details', $this->data);
	}

	function today_sale()
	{
		if (!$this->Admin) {
			$this->session->set_flashdata('error', lang('access_denied'));
			redirect($_SERVER["HTTP_REFERER"]);
		}

		$this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
		$this->data['ccsales'] = $this->pos_model->getTodayCCSales();
		$this->data['cashsales'] = $this->pos_model->getTodayCashSales();
		$this->data['chsales'] = $this->pos_model->getTodayChSales();
		$this->data['meiopagamento'] = $this->site->getAllmeiopagamento();
		$this->data['stripesales'] = $this->pos_model->getTodayStripeSales();
		$this->data['totalsales'] = $this->pos_model->getTodaySales();
		// $this->data['expenses'] = $this->pos_model->getTodayExpenses();
		$this->load->view($this->theme . 'pos/today_sale', $this->data);
	}

	function shortcuts()
	{
		$this->load->view($this->theme . 'pos/shortcuts', $this->data);
	}

	function view_bill()
    {
        $this->load->view($this->theme . 'pos/view_bill', $this->data);
    }

    function promotions()
    {
        $this->load->view($this->theme . 'promotions', $this->data);
    }

    function stripe_balance()
    {
        if (!$this->Owner) {
            return FALSE;
        }
        $this->load->model('stripe_payments');
        return $this->stripe_payments->get_balance();
    }

	function language($lang = false)
    {
        if ($this->input->get('lang')) {
            $lang = $this->input->get('lang');
        }
        //$this->load->helper('cookie');
        $folder = 'app/language/';
        $languagefiles = scandir($folder);
        if (in_array($lang, $languagefiles)) {
            $cookie = array(
                'name' => 'language',
                'value' => $lang,
                'expire' => '31536000',
                'prefix' => 'spos_',
                'secure' => false
            );

            $this->input->set_cookie($cookie);
        }
        redirect($_SERVER["HTTP_REFERER"]);
    }

    function validate_gift_card($no)
    {
        if ($gc = $this->pos_model->getGiftCardByNO(urldecode($no))) {
            if ($gc->expiry) {
                if ($gc->expiry >= date('Y-m-d')) {
                    echo json_encode($gc);
                } else {
                    echo json_encode(false);
                }
            } else {
                echo json_encode($gc);
            }
        } else {
            echo json_encode(false);
        }
    }

}
