<?php


/* creates a compressed zip file */
function create_zip($files = array(),$destination = '',$overwrite = false) {
	//if the zip file already exists and overwrite is false, return false
	if(file_exists($destination) && !$overwrite) { return false; }
	//vars
	$valid_files = array();
	//if files were passed in...
	if(is_array($files)) {
		//cycle through each file
		foreach($files as $file) {
			//make sure the file exists
			if(file_exists($file)) {
				$valid_files[] = $file;
			}
		}
	}
	//if we have good files...
	if(count($valid_files)) {
		//create the archive
		$zip = new ZipArchive();
		if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
			return false;
		}
		//add the files
		foreach($valid_files as $file) {
			$zip->addFile($file,$file);
		}
		//debug
		//echo 'The zip archive contains ',$zip->numFiles,' files with a status of ',$zip->status;
		
		//close the zip -- done!
		$zip->close();
		
		//check to make sure the file exists
		return file_exists($destination);
	}
	else
	{
		return false;
	}
}

$cnpj = $_REQUEST["cnpj"];
$mes = ($_GET["mes"])? $_GET["mes"] : date("m");
$ano = date("y");
$modelo = ($_GET["modelo"])? $_GET["modelo"] : 65;
$nomecomeza = $_REQUEST["codigoUF"].$ano.$mes.$cnpj.$modelo;
$files_to_zip = array();

$directory = './xml/autorizadas';
$scanned_directory = scandir($directory);
foreach($scanned_directory as $d){

    if (strpos($d, $nomecomeza) !== false) {
        $files_to_zip[] = $directory.'/'.$d;
    } 
    
}


$directory2 = './xml/canceladas';
$scanned_directory2 = scandir($directory2);
foreach($scanned_directory2 as $d2){

    if (strpos($d2, $nomecomeza) !== false) {
        $files_to_zip[] = $directory2.'/'.$d2;
    } 
    
}

$nameA = '/zip/NF-'.$cnpj.'-'.$modelo.'-'.$ano.'-'.$mes.'-'.date("ss").'.zip';
$result = create_zip($files_to_zip, '.'.$nameA);

if($result) $url = $nameA; 

//echo json_encode(array("result" => $result, "url" => $url));

  header("Content-Type: application/json");
         echo $_GET['callback'] . '(' . "{'result' : ".$result.", 'url': '".$url."'}" . ')';
         
